<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <title>Start 3D Midia</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.4.1/css/bootstrap.min.css'>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .card {
            margin-bottom: 20px;
            box-shadow: 0 8px 16px rgba(0,0,0,0.1);
            border-radius: 10px;
            overflow: hidden;
            height: 372px;
            transition: transform 0.3s ease-in-out;
            border: 2px solid #007bff;
            position: relative;
        }
        .card:hover {
            transform: translateY(-10px);
        }
        .card-img-top {
            width: 100%;
            max-height: 180px;
            object-fit: cover;
            background-color: #000;
            border-bottom: 2px solid #007bff;
        }
        .category-title {
            text-align: center;
            font-size: 2.5rem;
            margin-top: 20px;
            margin-bottom: 20px;
            text-shadow: 2px 2px 4px #87CEFA;
            background-color: rgba(0, 0, 0, 0.8);
            color: #ffffff;
            padding: 10px;
            border-radius: 10px;
        }
        .main-title {
            text-align: center;
            font-size: 6.75rem;
            margin-top: 100px;
            margin-bottom: 20px;
            text-shadow: 3px 3px 5px #87CEFA;
            color: #ffffff;
            letter-spacing: 2px;
        }
        .btn-primary, .btn-expand {
            background-color: #007bff;
            border-color: #007bff;
            width: calc(50% - 1px);
            margin: 0;
            position: absolute;
            bottom: 1px;
            border-radius: 0 0 10px 0;
        }
        .btn-primary {
            left: 1px;
            border-radius: 0 0 0 10px;
        }
        .btn-expand {
            right: 1px;
            border-radius: 0 0 10px 0;
        }
        .btn-primary:hover, .btn-expand:hover {
            background-color: #0056b3;
            border-color: #0056b3;
        }
        .card-body {
            padding: 15px;
            height: calc(100% - 210px);
            overflow: hidden;
            position: relative;
        }
        .card-text {
            font-size: 1rem;
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
        }
        @media (max-width: 768px) {
            .card {
                height: auto;
                margin-bottom: 30px;
            }
            .btn-primary, .btn-expand {
                width: 100%;
                position: relative;
                margin-top: 10px;
                border-radius: 0 0 5px 5px;
                left: 0;
                right: 0;
            }
        }
        .modal-img {
            width: 100%;
            height: auto;
            max-height: 80vh;
            object-fit: cover;
        }
        .modal-desc {
            margin-top: 10px;
            white-space: pre-wrap; /* Exibe quebras de linha sem tags HTML indesejadas */
        }
    </style>
    <!-- Open Graph meta tags for sharing -->
    <meta property="og:title" content="Start 3D Midia">
    <meta property="og:description" content="Confira nossa loja e nossos produtos incríveis!">
    <meta property="og:image" content="https://multp.s3dmidia.com.br/logo.png">
    <meta property="og:url" content="https://multp.s3dmidia.com.br/loja_link/admleo/index.php">
</head>
<body>
    <div class="container py-4">
        <h1 class="main-title">Start 3D Midia</h1>

        <?php
        $dataFile = 'data.json';
        $data = json_decode(file_get_contents($dataFile), true);

        if (isset($data['background']) && !empty($data['background'])) {
            echo '<style> body { background-image: url("' . $data['background'] . '"); background-size: cover; } </style>';
        }

        foreach ($data['categories'] as $category) {
            echo '<h2 class="category-title">' . htmlspecialchars($category) . '</h2>';
            echo '<div class="row">';
            $cardCount = 0;
            foreach ($data['cards'] as $card) {
                if ($card['category'] === $category) {
                    echo '<div class="col-md-3 col-sm-6 mb-4">';
                    echo '<div class="card animate__animated animate__fadeIn">';
                    echo '<img src="' . htmlspecialchars($card['imge']) . '" class="card-img-top" alt="Imagem do Card">';
                    echo '<div class="card-body">';
                    echo '<h5 class="card-title">' . htmlspecialchars($card['name']) . '</h5>';
                    echo '<p class="card-text">' . (strlen($card['desc']) > 150 ? substr(htmlspecialchars($card['desc']), 0, 150) . '...' : htmlspecialchars($card['desc'])) . '</p>';
                    echo '<a href="' . htmlspecialchars($card['url']) . '" class="btn btn-primary btn-sm">Quero</a>';
                    echo '<button class="btn btn-expand btn-sm" data-toggle="modal" data-target="#cardModal" data-title="' . htmlspecialchars($card['name']) . '" data-image="' . htmlspecialchars($card['imge']) . '" data-desc="' . htmlspecialchars($card['desc']) . '" data-url="' . htmlspecialchars($card['url']) . '">Expandir</button>';
                    echo '</div>';
                    echo '</div>';
                    echo '</div>';
                    $cardCount++;
                    if ($cardCount % 4 === 0) {
                        echo '</div><div class="row">';
                    }
                }
            }
            echo '</div>';
        }
        ?>

        <a href="manage.php" class="btn btn-secondary mt-4">Voltar para Gerenciamento</a>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="cardModal" tabindex="-1" aria-labelledby="cardModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="cardModalLabel">Imagem Expandida</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img src="" class="modal-img" alt="Imagem do Card">
                    <p class="modal-title-content"></p>
                    <p class="modal-desc"></p>
                    <a id="whatsappBtn" href="#" class="btn btn-success mt-3">Quero este</a>
                    <button id="shareBtn" class="btn btn-info mt-3">Compartilhar</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.4.1/js/bootstrap.min.js"></script>
    <script>
        $(document).ready(function() {
            $(window).scroll(function() {
                $('.card').each(function() {
                    var topOfElement = $(this).offset().top;
                    var bottomOfWindow = $(window).scrollTop() + $(window).height();

                    if (bottomOfWindow > topOfElement + 100) {
                        $(this).addClass('animate__fadeInUp');
                    }
                });
            });

            $('#cardModal').on('show.bs.modal', function (event) {
                var button = $(event.relatedTarget);
                var title = button.data('title');
                var image = button.data('image');
                var desc = button.data('desc');
                var url = button.data('url');
                var modal = $(this);

                modal.find('.modal-title').text(title);
                modal.find('.modal-img').attr('src', image);
                modal.find('.modal-desc').text(desc.replace(/<br\s*\/?>/g, '\n')); // Remove tags <br>

                var whatsappMessage = `Conheça nossa loja: https://multp.s3dmidia.com.br/loja_link/admleo/index.php\n\nTítulo: ${title}\nDescrição: ${desc.replace(/<br\s*\/?>/g, ' ')}\n\nVeja o item aqui: ${url}`;
                modal.find('#whatsappBtn').attr('href', 'https://wa.me/?text=' + encodeURIComponent(whatsappMessage));
            });

            $('#shareBtn').on('click', function() {
                var title = $('#cardModal').find('.modal-title').text();
                var image = $('#cardModal').find('.modal-img').attr('src');
                var desc = $('#cardModal').find('.modal-desc').text().replace(/<br\s*\/?>/g, '\n'); // Remove tags <br>
                var storeUrl = 'https://multp.s3dmidia.com.br/loja_link/admleo/index.php'; // Link da loja

                var shareText = `Conheça nossa loja: ${storeUrl}\n\nTítulo: ${title}\nDescrição: ${desc}\n\nVeja o item aqui: ${image}`;

                if (navigator.share) {
                    navigator.share({
                        title: title,
                        text: shareText,
                        url: image // A URL do item, não a do produto
                    }).catch(console.error);
                } else {
                    alert('Compartilhamento não suportado neste navegador.');
                }
            });
        });
    </script>
</body>
</html>
