<?php
session_start();

// Verifica se o usuário não está autenticado; se não estiver, redireciona para o login
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Função para carregar a lista de botões e categorias
function loadButtons() {
    $data = [
        'buttons' => [],
        'categories' => []
    ];

    if (file_exists('buttons.json')) {
        $data = json_decode(file_get_contents('buttons.json'), true);
    }

    return $data;
}

// Função para carregar as categorias existentes
function loadCategories() {
    $data = loadButtons();
    return $data['categories'];
}

// Verifica se o formulário de criação de botões foi submetido
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['create_button'])) {
    // Obtém os dados do formulário
    $button_name = $_POST['button_name'];
    $button_url = $_POST['button_url'];
    $button_category = $_POST['button_category'];

    // Carrega os botões existentes
    $data = loadButtons();
    $buttons = $data['buttons'];

    // Adiciona o novo botão
    $buttons[] = [
        'name' => $button_name,
        'url' => $button_url,
        'category' => $button_category
    ];

    // Atualiza a lista de botões no arquivo JSON
    $data['buttons'] = $buttons;
    file_put_contents('buttons.json', json_encode($data, JSON_PRETTY_PRINT));

    // Redireciona de volta para a página de configurações
    header("Location: settings.php");
    exit;
}

// Verifica se o formulário de criação de categorias foi submetido
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['create_category'])) {
    $category_name = $_POST['category_name'];
    $data = loadButtons();
    $categories = $data['categories'];

    // Adiciona a nova categoria
    $categories[] = $category_name;

    // Atualiza a lista de categorias no arquivo JSON
    $data['categories'] = $categories;
    file_put_contents('buttons.json', json_encode($data, JSON_PRETTY_PRINT));

    // Redireciona de volta para a página de configurações
    header("Location: settings.php");
    exit;
}

// Carrega os botões e categorias existentes
$data = loadButtons();
$buttons = $data['buttons'];
$categories = $data['categories'];
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configurações</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            padding: 50px;
        }
        form {
            max-width: 400px;
            margin: 0 auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 10px;
            font-weight: bold;
        }
        input[type="text"], select {
            width: 100%;
            padding: 8px;
            font-size: 1rem;
            border: 1px solid #ccc;
            border-radius: 4px;
            margin-bottom: 10px;
        }
        button {
            margin-top: 10px;
            padding: 15px 30px; /* Tamanho igual para ambos os botões */
            font-size: 1rem;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.3s;
            text-decoration: none; /* Remove sublinhado */
            display: inline-block;
        }
        button.logout {
            outline: none; /* Remove o contorno padrão apenas do botão "Sair" */
        }
        button:hover {
            background-color: #0056b3;
        }
        .category-list {
            text-align: left;
            margin-top: 20px;
        }
        .category-list li {
            margin-bottom: 5px;
        }
        .preview-container {
            margin-top: 20px;
            max-width: 600px;
            margin: 0 auto;
        }
        .background-preview {
            width: 100%;
            max-width: 600px;
            height: auto;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }
        .footer {
            position: fixed;
            bottom: 60px; /* Distância do rodapé ajustada para 60px */
            width: 100%;
            text-align: center;
        }
        .footer a.button {
            background-color: #007bff;
            color: #fff;
            padding: 15px 30px; /* Tamanho igual para ambos os botões */
            border-radius: 4px;
            text-decoration: none;
            transition: background-color 0.3s;
            margin: 0 10px; /* Espaço entre os botões */
            display: inline-block;
        }
        .footer a.button:first-child {
            position: absolute;
            left: 25%; /* 25% da lateral esquerda */
        }
        .footer a.button:last-child {
            position: absolute;
            right: 25%; /* 25% da lateral direita */
        }
        .footer a.button:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <h2>Configurações</h2>

    <!-- Formulário para criar novas categorias -->
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <h3>Criar Nova Categoria</h3>
        <label for="category_name">Nome da Categoria:</label>
        <input type="text" id="category_name" name="category_name" required>
        <button type="submit" name="create_category">Criar Categoria</button>
    </form>

    <!-- Formulário para adicionar novos botões -->
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <h3>Adicionar Novo Botão</h3>
        <label for="button_name">Nome do Botão:</label>
        <input type="text" id="button_name" name="button_name" required>
        <label for="button_url">URL do Botão:</label>
        <input type="text" id="button_url" name="button_url" required>
        <label for="button_category">Categoria do Botão:</label>
        <select id="button_category" name="button_category" required>
            <?php foreach ($categories as $category): ?>
                <option value="<?php echo htmlspecialchars($category); ?>"><?php echo htmlspecialchars($category); ?></option>
            <?php endforeach; ?>
        </select>
        <button type="submit" name="create_button">Criar Botão</button>
    </form>

    <!-- Listagem de categorias existentes -->
    <?php if (!empty($categories)): ?>
        <div class="category-list">
            <h3>Categorias</h3>
            <ul>
                <?php foreach ($categories as $category): ?>
                    <li><?php echo htmlspecialchars($category); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <!-- Listagem de botões existentes -->
    <?php if (!empty($buttons)): ?>
        <div class="category-list">
            <h3>Botões</h3>
            <ul>
                <?php foreach ($buttons as $index => $button): ?>
                    <li>
                        <strong><?php echo htmlspecialchars($button['name']); ?></strong> - 
                        <a href="<?php echo htmlspecialchars($button['url']); ?>" target="_blank"><?php echo htmlspecialchars($button['url']); ?></a>
                        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" style="display: inline;">
                            <input type="hidden" name="edit_index" value="<?php echo $index; ?>">
                            <input type="hidden" name="button_name" value="<?php echo htmlspecialchars($button['name']); ?>">
                            <input type="hidden" name="button_url" value="<?php echo htmlspecialchars($button['url']); ?>">
                            <input type="hidden" name="button_category" value="<?php echo htmlspecialchars($button['category']); ?>">
                            <button type="submit" name="edit_button">Editar</button>
                        </form>
                    </li