<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    
        <!-- Favicon -->
    <link rel="icon" href="favicon.png" type="image/png">

    <!-- Open Graph Metadata para WhatsApp e outras redes sociais -->
    <meta property="og:title" content="Central Start 3D Mídia">
    <meta property="og:description" content="Bem-vindo ao Central Start 3D Mídia. Clique para ver mais!">
    <meta property="og:image" content="https://master.s3dmidia.com.br/favicon.png"> <!-- URL completa da imagem -->
    <meta property="og:url" content="https://master.s3dmidia.com.br/login.php"> <!-- URL do seu site -->
    <meta property="og:type" content="website">
    <meta property="og:image:width" content="1200"> <!-- Largura da imagem -->
    <meta property="og:image:height" content="630"> <!-- Altura da imagem -->

    <!-- Twitter Card Metadata -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Central Start 3D Mídia">
    <meta name="twitter:description" content="Bem-vindo ao Central Start 3D Mídia. Clique para ver mais!">
    <meta name="twitter:image" content="https://master.s3dmidia.com.br/logo.png">
    
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }

        .login-container {
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            padding: 30px;
            width: 300px;
            text-align: center;
            margin-bottom: 20px;
        }

        .login-container h2 {
            color: #333333;
            margin-bottom: 20px;
        }

        .login-container input[type="text"],
        .login-container input[type="password"] {
            width: 100%;
            padding: 12px;
            margin: 10px 0;
            box-sizing: border-box;
            border: 1px solid #dddddd;
            border-radius: 4px;
            font-size: 14px;
            transition: border-color 0.3s ease;
        }

        .login-container input[type="text"]:focus,
        .login-container input[type="password"]:focus {
            outline: none;
            border-color: #007bff;
        }

        .login-container button {
            background-color: #007bff;
            color: #ffffff;
            padding: 12px 0;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            width: 100%;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }

        .login-container button:hover {
            background-color: #0056b3;
        }

        .message {
            color: #ff0000;
            margin-top: 10px;
            text-align: center;
        }

        .info-container {
            text-align: center;
            font-size: 14px;
            line-height: 1.6;
            max-width: 600px;

        }
        
       .section-title {
            font-size: 36px;
            font-weight: bold;
            margin-bottom: 20px;
            text-shadow: 3px 3px 10px rgba(0, 0, 0, 0.8);
        }
        
      .logo {
            max-width: 150px;
            margin: 0 auto 20px;
        }
    </style>
</head>
<body> 


        <!-- Logomarca -->
        <img src="logo.png" alt="Logomarca" class="logo">

        <!-- Título -->
        <div class="section-title">
            <center>Central <br>Start 3D Mídia</center>
        </div><p>
        
        
        
    <div class="login-container">
        <h2>Login</h2>
<?php
$caminhoArquivo = '.eggziepanels.db';

if (!file_exists($caminhoArquivo)) {
    echo "<font color='red'>[Atenção]</font><p>Usuario e senha do Admin ainda não existe,<br> digite o usuario e senha para criá lo.";
}
?>
        <form action="check.php" method="post">
            <input type="text" name="usuario" placeholder="Nome de usuário" required>
            <input type="password" name="senha" placeholder="Senha" required>
            <button type="submit">Entrar</button>
        </form>
    </div>

    <div class="info-container">
        <p>Bem-vindo à Central de Ferramentas da Start 3D Mídia!</p>
        <p>Aqui você organiza seus links, painéis, encurtadores e muito mais.</p>
        <p>Tudo separadinho por categorias para facilitar sua vida online.</p>
        <p>E o melhor: nossa área de configurações é super segura, só entra com usuário e senha.</p>


    </div>
</body>
</html>
