<?php
session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}

// Verifica se o ID do usuário foi enviado
if (isset($_GET['id']) && !empty($_GET['id']) && is_numeric($_GET['id'])) {
    $id = intval($_GET['id']);

    // Conecta ao banco de dados
    $db = new SQLite3('.listausuarios.db');

    // Obtém a data de vencimento atual do usuário
    $stmt = $db->prepare('SELECT datavencimento FROM USERS WHERE id = :id');
    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
    $result = $stmt->execute()->fetchArray(SQLITE3_ASSOC);

    if ($result) {
        $dataVencimentoAtual = $result['datavencimento'];

        // Verifica se a data de vencimento é válida
        if ($dataVencimentoAtual) {
            // Cria um objeto DateTime com a data de vencimento atual
            $dataVencimento = new DateTime($dataVencimentoAtual);
            $dataAtual = new DateTime(); // Data atual

            // Se a data de vencimento for anterior à data atual, reinicia para a data atual
            if ($dataVencimento < $dataAtual) {
                $dataVencimento = $dataAtual; // Nova data de vencimento começa hoje
            }

            // Adiciona um mês à nova data de vencimento
            $dataVencimento->modify('+1 month');
            $novoVencimento = $dataVencimento->format('Y-m-d');

            // Prepara a consulta de atualização
            $stmt = $db->prepare('UPDATE USERS SET datavencimento = :datavencimento WHERE id = :id');
            $stmt->bindValue(':datavencimento', $novoVencimento, SQLITE3_TEXT);
            $stmt->bindValue(':id', $id, SQLITE3_INTEGER);

            // Executa a consulta
            if ($stmt->execute()) {
                // Redireciona de volta com uma mensagem de sucesso
                echo "<script>
                        alert('Assinatura renovada com sucesso! Novo vencimento: $novoVencimento');
                        window.location.href = 'listausuarios.php?option=iniciar';
                      </script>";
            } else {
                // Redireciona de volta com uma mensagem de erro
                echo "<script>
                        alert('Erro ao renovar a assinatura.');
                        window.location.href = 'listausuarios.php?option=iniciar';
                      </script>";
            }
        } else {
            echo "<script>
                    alert('Data de vencimento não encontrada.');
                    window.location.href = 'listausuarios.php?option=iniciar';
                  </script>";
        }
    } else {
        echo "<script>
                alert('Usuário não encontrado.');
                window.location.href = 'listausuarios.php?option=iniciar';
              </script>";
    }
} else {
    echo "<script>
            alert('ID inválido.');
            window.location.href = 'listausuarios.php?option=iniciar';
          </script>";
}
?>
