<?php
// Configurações de exibição de erros (somente para ambiente de desenvolvimento)
ini_set("display_errors", 0);
ini_set("display_startup_errors", 0);
error_reporting(E_ALL);

session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}

// Função para sanitizar entradas de texto
function sanitizeInput($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

// Função para validar e criar um usuário
function criarUsuario($usuario, $senha) {
    $db_check = new SQLite3('.admin.db');
    
    $stmt = $db_check->prepare('UPDATE USERS SET USERNAME = :usuario, PASSWORD = :senha WHERE id = 1');
    $stmt->bindValue(':usuario', $usuario, SQLITE3_TEXT);
    $stmt->bindValue(':senha', $senha, SQLITE3_TEXT);

    if ($stmt->execute()) {
        echo "<script>alert('O perfil foi alterado com sucesso.');</script>";
        echo "<script>window.location.href='perfil.php';</script>";
    } else {
        echo "<script>alert('Erro ao atualizar o perfil.');</script>";
        echo "<script>window.location.href='perfil.php';</script>";
    }
    
    $db_check->close();
}

if (isset($_GET["option"]) && $_GET["option"] == "salvar") {
    $usuario = sanitizeInput($_POST['usuario']);
    $senha = sanitizeInput($_POST['senha']);
    
    if (!empty($usuario) && !empty($senha)) {
        criarUsuario($usuario, $senha);
    } else {
        echo "<script>alert('Erro: preencha todos os campos.');</script>";
    }
}

// Obtém os dados atuais do usuário
$db_check1 = new SQLite3('.admin.db');
$sql_check = 'SELECT * from USERS WHERE id = 1';
$ret_check = $db_check1->query($sql_check);

while ($row_check = $ret_check->fetchArray()) {
    $usuario = $row_check['USERNAME'];
    $senha = $row_check['PASSWORD'];
}

$db_check1->close();
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Perfil Master</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f4f4;
            color: #333;
        }
        #sidebar {
            background-color: #343a40;
            color: #fff;
            height: 100vh;
        }
        #content {
            padding: 20px;
        }
        h1 {
            font-size: 2.5rem;
            text-align: center;
            color: #007bff;
            margin-bottom: 20px;
        }
        form {
            background-color: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            margin: auto;
        }
        form label {
            font-weight: bold;
            margin-bottom: 10px;
            color: #495057;
        }
        form input {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ced4da;
            border-radius: 15px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }
        form input:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
            outline: none;
        }
        form button {
            width: 100%;
            padding: 10px;
            background-color: #28a745;
            color: #fff;
            border: none;
            border-radius: 5px;
            font-size: 1.2rem;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        form button:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'laterais.php'; ?>
            <main role="main" class="col-md-9 col-lg-10 px-md-4" id="content">
                <h1><i class="fas fa-user-cog"></i> Login e senha para acessar o Gestor</h1>
                <form id="form" action="perfil.php?option=salvar" method="post" onsubmit="return confirmAlteracao();">
                    <div class="form-group">
                        <label for="usuario"><i class="fas fa-user"></i> Usuário:</label>
                        <input type="text" id="usuario" value="<?php echo $usuario; ?>" name="usuario" required>
                    </div>
                    <div class="form-group">
                        <label for="senha"><i class="fas fa-lock"></i> Senha:</label>
                        <input type="password" id="senha" name="senha" required>
                    </div>
                    <button type="submit"><i class="fas fa-save"></i> Salvar</button>
                </form>
            </main>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function confirmAlteracao() {
            return confirm('Tem certeza que deseja alterar o login e a senha?');
        }
    </script>
</body>
</html>
