<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestor de clientes</title>
    
    <!-- Metadados para compartilhamento -->
    <meta name="description" content="monitoramento de clientes.">
    <meta name="keywords" content="login, segurança, sistema, autenticação">
    <meta name="author" content="develop dev Robert Wilker">
    <meta property="og:title" content="Gerencie seus clientes">
    <meta property="og:description" content="Acesse o sistema de forma segura com seu login e senha.">
    <meta property="og:image" content="https://i.postimg.cc/BbhSsMQG/logo.png">
    <meta property="og:url" content="https://gestor.grupotvon.com/login">
    <meta property="og:type" content="website">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Login - Sistema Seguro">
    <meta name="twitter:description" content="Acesse o sistema de forma segura com seu login e senha.">
    <meta name="twitter:image" content="https://i.postimg.cc/BbhSsMQG/logo.png">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    <style>
        @keyframes gradientMovement {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        body {
            font-family: Arial, sans-serif;
            margin: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
            background-image: url('imagem/fundo.gif'), url('imagem/fundo.jpg'), url('imagem/fundo.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }

        .login-container {
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
            padding: 25px;
            width: 100%;
            max-width: 350px;
            text-align: center;
            background: linear-gradient(135deg, #0072ff, #434343, #bcbcbc);
            background-size: 300% 300%;
            animation: gradientMovement 10s ease infinite;
            color: white;
            margin-top: 20px; /* Espaçamento superior para evitar colar no topo */
        }

        .login-container h2 {
            color: white;
            margin-bottom: 20px;
        }

        .login-container img {
            width: 100px;
            margin-bottom: 20px;
        }

        .login-container .input-group {
            position: relative;
            margin-bottom: 15px;
        }

        .login-container .input-group input {
            width: 100%;
            padding: 12px;
            padding-left: 40px; /* Espaçamento para o ícone */
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 16px;
        }

        .login-container .input-group i {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 18px;
        }

        .login-container .input-group .icon-user {
            color: #4caf50;
        }

        .login-container .input-group .icon-lock {
            color: #f39c12;
        }

        .login-container button {
            background-color: #4caf50;
            color: #fff;
            padding: 12px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            width: 100%;
            font-size: 16px;
            margin-top: 10px;
            transition: background-color 0.3s ease;
        }

        .login-container button:hover {
            background-color: #45a049;
        }

        .login-container p {
            color: #dddddd;
            margin-top: 15px;
            font-size: 14px;
        }

        @media (max-width: 768px) {
            .login-container {
                padding: 20px;
                max-width: 90%;
                margin: 10px; /* Adiciona margem lateral para evitar tocar as bordas */
            }

            .login-container img {
                width: 80px;
            }

            .login-container input, .login-container button {
                padding: 10px;
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <img src="https://i.postimg.cc/BbhSsMQG/logo.png" alt="Logo">
        <?php
        $caminhoArquivo = '.admin.db';
        if (!file_exists($caminhoArquivo)) {
            echo "<font color='red'>[Atenção]</font><p>Usuário e senha do Admin ainda não existem,<br> digite o usuário e senha para criá-lo.";
        }
        ?>
        <h2>Gestor<br>de<br>Clientes</h2>
        <form action="check.php" method="post">
            <div class="input-group">
                <i class="fas fa-user icon-user"></i>
                <input type="text" name="usuario" placeholder="Nome de usuário" required>
            </div>
            <div class="input-group">
                <i class="fas fa-lock icon-lock"></i>
                <input type="password" name="senha" placeholder="Senha" required>
            </div>
            <button type="submit"><i class="fas fa-key"></i> Entrar</button>
        </form>
        <p>Desenvolvido por Grupo RTVon<br> Idealizaçoes Robert Wilker</p>
    </div>
</body>
</html>
