<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel de Controle</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        #topbar {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            background-color: #343a40;
            color: white;
            padding: 10px 20px;
            z-index: 1100;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        #topbar .logo-container {
            margin: 0;
        }

        #topbar .logo {
            height: 40px;
        }

        #sidebar {
            background-color: #343a40;
            min-height: 100vh;
            padding-top: 20px;
            position: fixed;
            top: 50px; 
            left: 0;
            width: 250px; 
            z-index: 1000;
            transition: transform 0.3s ease-in-out;
        }

        #content {
            margin-left: 250px;
            margin-top: 50px;
            padding: 20px;
        }

        .logo-container {
            text-align: center;
            margin-bottom: 20px;
            padding: 0 10px;
            box-sizing: border-box;
        }

        .logo {
            width: 50px;
            height: auto;
            display: block;
            margin: 0 auto;
        }

        .nav {
            margin: 0;
            padding: 0;
            list-style: none;
        }

        .nav-item {
            margin-bottom: 1rem;
            position: relative;
        }

        .nav-link {
            display: block;
            font-size: 1.1rem;
            padding: 15px 20px;
            position: relative;
            border: 2px solid transparent;
            border-radius: 5px;
            background-color: #343a40;
            color: #fff;
            transition: color 0.3s, border-color 0.3s;
            overflow: hidden;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.5);
        }

        .nav-link:hover {
            background-color: #495057;
        }

        .nav-link i {
            vertical-align: middle;
            margin-right: 8px;
        }

        #menu-toggle {
            display: none; 
            position: absolute;
            top: 10px;
            left: 80px;
            background-color: #343a40;
            color: white;
            border: none;
            padding: 10px;
            font-size: 1.5rem;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            text-align: center;
            line-height: 30px;
            z-index: 1100;
        }

        @media (max-width: 767.98px) {
            #sidebar {
                transform: translateX(-100%);
                width: 75%; 
            }

            #menu-toggle {
                display: block; 
            }

            #sidebar.active {
                transform: translateX(0);
            }

            #content {
                margin-left: 0;
            }
        }

        /* Animação do brilho neon azul e branco */
        @keyframes neonGlow {
            0% {
                border-color: rgba(0, 0, 255, 0.9);
                box-shadow: 0 0 5px rgba(0, 0, 255, 0.9), 
                            0 0 10px rgba(0, 0, 255, 0.9), 
                            0 0 15px rgba(0, 0, 255, 0.9), 
                            0 0 20px rgba(0, 0, 255, 0.9), 
                            0 0 25px rgba(0, 0, 255, 0.9);
            }
            25% {
                border-color: rgba(0, 0, 230, 0.8);
                box-shadow: 0 0 5px rgba(0, 0, 230, 0.8), 
                            0 0 10px rgba(0, 0, 230, 0.8), 
                            0 0 15px rgba(0, 0, 230, 0.8), 
                            0 0 20px rgba(0, 0, 230, 0.8), 
                            0 0 25px rgba(0, 0, 230, 0.8);
            }
            50% {
                border-color: rgba(0, 0, 200, 0.7);
                box-shadow: 0 0 5px rgba(0, 0, 200, 0.7), 
                            0 0 10px rgba(0, 0, 200, 0.7), 
                            0 0 15px rgba(0, 0, 200, 0.7), 
                            0 0 20px rgba(0, 0, 200, 0.7), 
                            0 0 25px rgba(0, 0, 200, 0.7);
            }
            75% {
                border-color: rgba(255, 255, 255, 0.9);
                box-shadow: 0 0 5px rgba(255, 255, 255, 0.9), 
                            0 0 10px rgba(255, 255, 255, 0.9), 
                            0 0 15px rgba(255, 255, 255, 0.9), 
                            0 0 20px rgba(255, 255, 255, 0.9), 
                            0 0 25px rgba(255, 255, 255, 0.9);
            }
            100% {
                border-color: rgba(255, 255, 255, 0.9);
                box-shadow: 0 0 5px rgba(255, 255, 255, 0.9), 
                            0 0 10px rgba(255, 255, 255, 0.9), 
                            0 0 15px rgba(255, 255, 255, 0.9), 
                            0 0 20px rgba(255, 255, 255, 0.9), 
                            0 0 25px rgba(255, 255, 255, 0.9);
            }
        }

        /* Nova animação laranja para o botão "Central De Links" */
        @keyframes orangeGlow {
            0%, 100% {
                border-color: rgba(255, 127, 24, 0.9);
                box-shadow: 0 0 5px rgba(255, 127, 24, 0.9),
                            0 0 10px rgba(255, 127, 24, 0.9),
                            0 0 15px rgba(255, 127, 24, 0.9),
                            0 0 20px rgba(255, 127, 24, 0.9),
                            0 0 25px rgba(255, 127, 24, 0.9);
            }
            0% {
                border-color: rgba(255, 200, 100, 0.8);
                box-shadow: 0 0 5px rgba(255, 200, 100, 0.8),
                            0 0 10px rgba(255, 200, 100, 0.8),
                            0 0 15px rgba(255, 200, 100, 0.8),
                            0 0 20px rgba(255, 200, 100, 0.8),
                            0 0 25px rgba(255, 200, 100, 0.8);
            }
        }

        /* Animação em cascata para os botões */
        .nav-item:nth-child(1) .nav-link {
            animation: neonGlow 12s ease-in-out infinite;
            animation-delay: 0s;
        }
        .nav-item:nth-child(2) .nav-link {
            animation: neonGlow 12s ease-in-out infinite;
            animation-delay: 2s;
        }
        .nav-item:nth-child(3) .nav-link {
            animation: neonGlow 12s ease-in-out infinite;
            animation-delay: 4s;
        }
        .nav-item:nth-child(4) .nav-link {
            animation: neonGlow 12s ease-in-out infinite;
            animation-delay: 6s;
        }
        .nav-item:nth-child(5) .nav-link {
            animation: orangeGlow 12s ease-in-out infinite; /* Aplicando animação laranja aqui */
            animation-delay: 8s;
        }
        .nav-item:nth-child(6) .nav-link {
            animation: neonGlow 12s ease-in-out infinite;
            animation-delay: 10s;
        }
        .nav-item:nth-child(7) .nav-link {
            animation: neonGlow 12s ease-in-out infinite;
            animation-delay: 12s;
        }
        .nav-item:nth-child(8) .nav-link {
            animation: neonGlow 12s ease-in-out infinite;
            animation-delay: 14s;
        }
        .nav-item:nth-child(9) .nav-link {
            animation: neonGlow 12s ease-in-out infinite;
            animation-delay: 16s;
        }
        .nav-item:nth-child(10) .nav-link {
            animation: neonGlow 12s ease-in-out infinite;
            animation-delay: 18s;
        }
        .nav-item:nth-child(11) .nav-link {
            animation: neonGlow 12s ease-in-out infinite;
            animation-delay: 19s;
        }
    </style>
</head>
<body>

<div id="topbar">
    <div class="logo-container">
        <a href="imagem/logo.png" target="_blank">
            <img src="imagem/logo.png" alt="Logo" class="logo">
        </a>
    </div>
    <button id="menu-toggle" class="btn btn-dark d-md-none">
        <i class="fas fa-bars"></i>
    </button>
</div>

<nav id="sidebar" class="col-md-3 col-lg-2 d-md-block bg-dark text-white">
    <div class="sidebar-sticky">
        <ul class="nav flex-column">
            <li class="nav-item" data-index="0">
                <a class="nav-link text-white" href="index.php">
                    <i class="fas fa-home" style="color: #007bff;"></i>
                    Inicio
                </a>
            </li>
            <li class="nav-item" data-index="1">
                <a class="nav-link text-white" href="listausuarios.php?option=iniciar">
                    <i class="fas fa-users" style="color: #28a745;"></i>
                    Usuários
                </a>
            </li>
            <li class="nav-item" data-index="2">
                <a class="nav-link text-white" href="criar.php">
                    <i class="fas fa-user-plus" style="color: #ffc107;"></i>
                    Cadastro
                </a>
            </li>
            <li class="nav-item" data-index="3">
                <a class="nav-link text-white" href="grafico.php">
                    <i class="fas fa-chart-line" style="color: #17a2b8;"></i>
                    Graficos
                </a>
            <li class="nav-item" data-index="4">
                <a id="centralDeLinks" class="nav-link text-white" href="/gestor/Centraldeliks/index.php" target="_blank">
                    <i class="fas fa-link" style="color: #FF7F24;"></i> <!-- Ícone de link -->
                    Central De Links
                </a>
            </li>
            <script>
                // Função que controla o pop-up
                function showPopup() {
                    // Obtém a data atual no formato YYYY-MM-DD
                    const today = new Date().toISOString().split('T')[0];
            
                    // Verifica a última data que o pop-up foi mostrado no LocalStorage
                    const lastPopupDate = localStorage.getItem("lastPopupDate");
            
                    // Se o pop-up não foi mostrado hoje, exibe-o
                    if (lastPopupDate !== today) {
                        alert("Seu login e senha para entrar é admin admin.");
            
                        // Atualiza o LocalStorage com a data atual
                        localStorage.setItem("lastPopupDate", today);
                    }
            
                    // Após o pop-up, redireciona para o link
                    window.location.href = document.getElementById("centralDeLinks").href;
                }
            
                // Adiciona o evento de clique no link
                document.getElementById("centralDeLinks").addEventListener("click", function(event) {
                    event.preventDefault(); // Evita que o link seja aberto imediatamente
                    showPopup(); // Exibe o pop-up (se necessário) e redireciona
                });
            </script>
            <li class="nav-item" data-index="5">
                <a class="nav-link text-white" href="perfil.php">
                    <i class="fas fa-user" style="color: #FF7F24;"></i>
                    Perfil
                </a>
            </li>
            <li class="nav-item" data-index="6">
                <a class="nav-link text-white" href="https://rtvon.xyz/Cart%C3%A3o-de-visita" target="_blank">
                    <i class="fas fa-headset" style="color: #FF7F24;"></i>
                    Suporte
                </a>
                        <!DOCTYPE html>
            <html lang="pt-BR">
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>Gerenciar Backup</title>
                <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
                <style>
                    /* Estilos do pop-up */
                    #popup {
                        display: none;
                        position: fixed;
                        left: 50%;
                        top: 50%;
                        transform: translate(-50%, -50%);
                        background-color: white;
                        padding: 20px;
                        border-radius: 8px;
                        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
                        z-index: 1000;
                        width: 300px;
                        text-align: center;
                    }
                    #overlay {
                        display: none;
                        position: fixed;
                        left: 0;
                        top: 0;
                        width: 100%;
                        height: 100%;
                        background: rgba(0, 0, 0, 0.5);
                        z-index: 999;
                    }
                    .button-close {
                        background-color: #28a745;
                        color: white;
                        border: none;
                        border-radius: 5px;
                        padding: 10px;
                        cursor: pointer;
                    }
                    .button-close:hover {
                        background-color: #218838;
                    }
                </style>
            </head>
            <body>
            
            <!-- Overlay e Pop-up -->
            <div id="overlay"></div>
            <div id="popup">
                <h2>Importante!</h2>
                <p style="color: black;">É importante fazer o backup do seu banco de dados de tempos em tempos. Caso não haja alterações, você pode deletar a cópia mais antiga e manter o backup mais recente.</p>
                <button class="button-close" onclick="confirmarBackup()">Continuar para o Backup</button>
            </div>
            
            <!-- Botão Gerenciar Backup -->
            <li class="nav-item" data-index="7">
                <a class="nav-link text-white" href="#" onclick="abrirBackup(event)">
                    <i class="fas fa-database" style="color: #28a745;"></i>
                    Gerenciar Backup
                </a>
            </li>
            
            <script>
                function abrirBackup(event) {
                    event.preventDefault(); // Impede o redirecionamento imediato
                    document.getElementById('popup').style.display = 'block';
                    document.getElementById('overlay').style.display = 'block';
                }
            
                function confirmarBackup() {
                    fecharPopup();
                    window.location.href = "backup_upload.php"; // Redireciona para a página de backup
                }
            
                function fecharPopup() {
                    document.getElementById('popup').style.display = 'none';
                    document.getElementById('overlay').style.display = 'none';
                }
            </script>
            
            </body>
            </html>
            </li>
            </li>
            <li class="nav-item" data-index="7">
                <a class="nav-link text-white" href="logout.php">
                    <i class="fas fa-sign-out-alt" style="color: #dc3545;"></i>
                    Sair
                </a>
            </li>
        </ul>
    </div>
</nav>

<script>
    document.getElementById('menu-toggle').addEventListener('click', function() {
        var sidebar = document.getElementById('sidebar');
        sidebar.classList.toggle('active');
    });
</script>

</body>
</html>
