<?php
session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}

// Função para sanitizar entradas de texto
function sanitizeInput($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

    $db_check = new SQLite3('.listausuarios.db');
    $db_check->exec('CREATE TABLE IF NOT EXISTS USERS(
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        nome TEXT,
        descricao TEXT, 
        whatsapp TEXT, 
        datavencimento TEXT, 
        datainicio TEXT, 
        servidor TEXT, 
        conexao TEXT, 
        nomedoapk TEXT, 
        macdoapk TEXT, 
        chavedoapk TEXT, 
        tipodedispositivo TEXT, 
        indicacao TEXT
    )');
    
    
// Função para validar e criar um usuário
function editar($id, $nome, $descricao, $whatsapp, $datavencimento, $datainicio, $servidor, $conexao, $nomedoapk, $macdoapk, $chavedoapk, $tipodedispositivo, $indicacao) {
    $db_check = new SQLite3('.listausuarios.db');
    $db_check->exec('CREATE TABLE IF NOT EXISTS USERS(
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        nome TEXT,
        descricao TEXT, 
        whatsapp TEXT, 
        datavencimento TEXT, 
        datainicio TEXT, 
        servidor TEXT, 
        conexao TEXT, 
        nomedoapk TEXT, 
        macdoapk TEXT, 
        chavedoapk TEXT, 
        tipodedispositivo TEXT, 
        indicacao TEXT
    )');

    $stmt = $db_check->prepare('SELECT COUNT(*) AS total FROM USERS WHERE id = :id');
    $stmt->bindValue(':id', $id, SQLITE3_TEXT);
    $result = $stmt->execute()->fetchArray();

    if ($result['total'] == 0) {
        echo "<script>alert('Erro: usuário não existe.');</script>";
        echo "<script>window.location.href='listausuarios.php?option=iniciar';</script>";
    } else {
    // Prepara a consulta de atualização
    $stmt = $db_check->prepare('UPDATE USERS SET
        nome = :nome,
        descricao = :descricao,
        whatsapp = :whatsapp,
        datavencimento = :datavencimento,
        datainicio = :datainicio,
        servidor = :servidor,
        conexao = :conexao,
        nomedoapk = :nomedoapk,
        macdoapk = :macdoapk,
        chavedoapk = :chavedoapk,
        tipodedispositivo = :tipodedispositivo,
        indicacao = :indicacao
        WHERE id = :id');
    
    $stmt->bindValue(':nome', $nome, SQLITE3_TEXT);
    $stmt->bindValue(':descricao', $descricao, SQLITE3_TEXT);
    $stmt->bindValue(':whatsapp', $whatsapp, SQLITE3_TEXT);
    $stmt->bindValue(':datavencimento', $datavencimento, SQLITE3_TEXT);
    $stmt->bindValue(':datainicio', $datainicio, SQLITE3_TEXT);
    $stmt->bindValue(':servidor', $servidor, SQLITE3_TEXT);
    $stmt->bindValue(':conexao', $conexao, SQLITE3_TEXT);
    $stmt->bindValue(':nomedoapk', $nomedoapk, SQLITE3_TEXT);
    $stmt->bindValue(':macdoapk', $macdoapk, SQLITE3_TEXT);
    $stmt->bindValue(':chavedoapk', $chavedoapk, SQLITE3_TEXT);
    $stmt->bindValue(':tipodedispositivo', $tipodedispositivo, SQLITE3_TEXT);
    $stmt->bindValue(':indicacao', $indicacao, SQLITE3_TEXT);
    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
    
    if ($stmt->execute()) {
        echo "<script>alert('Dados atualizados com sucesso.');</script>";
        echo "<script>window.location.href='listausuarios.php?option=iniciar';</script>";
    } else {
        echo "<script>alert('Erro ao atualizar dados.');</script>";
        echo "<script>window.location.href='editar.php?option=editar&id=$id';</script>";
    }
    
    $db_check->close();

    }

    $db_check->close();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = sanitizeInput($_POST['id']);
    
    $nome = sanitizeInput($_POST['nome']);
            
    $descricao = sanitizeInput($_POST['descricao']);
    $whatsapp = sanitizeInput($_POST['whatsapp']);
    $datavencimento = sanitizeInput($_POST['datavencimento']);
    
    $datainicio = sanitizeInput($_POST['datainicio']);
    $servidor = sanitizeInput($_POST['servidor']);
    $conexao = sanitizeInput($_POST['conexao']);
    $nomedoapk = sanitizeInput($_POST['nomedoapk']);
    $macdoapk = sanitizeInput($_POST['macdoapk']);
    $chavedoapk = sanitizeInput($_POST['chavedoapk']);
    $tipodedispositivo = sanitizeInput($_POST['tipodedispositivo']);
    $indicacao = sanitizeInput($_POST['indicacao']);

    if (!empty($id) && !empty($nome) && !empty($descricao) && !empty($whatsapp) && !empty($datavencimento) && !empty($datainicio) && !empty($servidor) && !empty($conexao) && !empty($nomedoapk) && !empty($macdoapk) && !empty($chavedoapk) && !empty($tipodedispositivo) && !empty($indicacao)) {
        editar($id, $nome, $descricao, $whatsapp, $datavencimento, $datainicio, $servidor, $conexao, $nomedoapk, $macdoapk, $chavedoapk, $tipodedispositivo, $indicacao);
    } else {
        echo "<script>alert('Erro: preencha todos os campos.');</script>";
    }
}




if (isset($_GET["option"]) && $_GET["option"] == "editar" && isset($_GET["id"])) {
    $id = $_GET["id"];
    
    // Prepara a consulta para evitar SQL Injection
    $stmt = $db_check->prepare('SELECT * FROM USERS WHERE id = :id');
    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
    $result = $stmt->execute();

    if ($row = $result->fetchArray(SQLITE3_ASSOC)) {
        // Extração de dados com proteção
        $nome = htmlspecialchars($row['nome']);
        $descricao = htmlspecialchars($row['descricao']);
        $whatsapp = htmlspecialchars($row['whatsapp']);
        $datavencimento = htmlspecialchars($row['datavencimento']);
        $datainicio = htmlspecialchars($row['datainicio']);
        $servidor = htmlspecialchars($row['servidor']);
        $conexao = htmlspecialchars($row['conexao']);
        $nomedoapk = htmlspecialchars($row['nomedoapk']);
        $macdoapk = htmlspecialchars($row['macdoapk']);
        $chavedoapk = htmlspecialchars($row['chavedoapk']);
        $tipodedispositivo = htmlspecialchars($row['tipodedispositivo']);
        $indicacao = htmlspecialchars($row['indicacao']);
    } else {
        echo "<script>window.location.href='listausuarios.php?option=iniciar';</script>";
        //echo "<div class=\"alert alert-warning\">Usuário não encontrado.</div>";
    }
    
    $db_check->close();
}


?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f4f4;
            color: #333;
        }

        #sidebar {
            background-color: #343a40;
            color: #fff;
            height: 100vh;
        }

        #content {
            padding: 20px;
        }

        h1 {
            font-size: 2.5rem;
            text-align: center;
            color: #007bff;
            margin-bottom: 20px;
        }

        form {
            background-color: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            margin: auto;
        }

        form label {
            font-weight: bold;
            margin-bottom: 10px;
            color: #495057;
        }

        form input {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ced4da;
            border-radius: 15px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        form input:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
            outline: none;
        }

        form button {
            width: 100%;
            padding: 10px;
            background-color: #28a745;
            color: #fff;
            border: none;
            border-radius: 5px;
            font-size: 1.2rem;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        form button:hover {
            background-color: #218838;
        }

        table {
            width: 100%;
            margin-top: 30px;
            border-collapse: collapse;
        }

        table th, table td {
            padding: 12px;
            text-align: left;
            border: 1px solid #dee2e6;
        }

        table th {
            background-color: #007bff;
            color: white;
        }

        @media (max-width: 768px) {
            form {
                padding: 20px;
            }

            h1 {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'laterais.php'; ?>
            <main role="main" class="col-md-9 col-lg-10 px-md-4" id="content">
                <h1>Página de Administração</h1>
                
                <form action="editar.php?token=editar" method="post">
                    <label for="nome">Nome do Cliente:</label>
                    
                    <input type="hidden" name="id" value="<?php echo htmlspecialchars($id); ?>">
                    
                    <input type="text" value="<?php echo $nome; ?>" id="nome" name="nome" required>
                    
                    <label for="whatsapp">Whatsapp:</label>
                    <input type="text" value="<?php echo $whatsapp; ?>" id="whatsapp" name="whatsapp" required>
                                        
                    <label for="descricao">Descricao:</label>
                    <input type="text" value="<?php echo $descricao; ?>" id="descricao" name="descricao" required>
                                        
                    <label for="datainicio">Data de Início:</label>
                    <input type="date" value="<?php echo $datainicio; ?>" id="datainicio" name="datainicio" required>
                    
                    <label for="datavencimento">Data de Vencimento:</label>
                    <input type="date" value="<?php echo $datavencimento; ?>" id="datavencimento" name="datavencimento" required>
                                        
                    <label for="servidor">Servidor:</label>
                    <input type="text" value="<?php echo $servidor; ?>" id="servidor" name="servidor" required>
                    
                    <label for="conexao">Conexão:</label>
                    <input type="text" value="<?php echo $conexao; ?>" id="conexao" name="conexao" required>
                    
                    <label for="nomedoapk">Nome do Apk:</label>
                    <input type="text" value="<?php echo $nomedoapk; ?>" id="nomedoapk" name="nomedoapk" required>

                    <label for="macdoapk">Mac do Apk:</label>
                    <input type="text" value="<?php echo $macdoapk; ?>" id="macdoapk" name="macdoapk" required> 
                    
                    <label for="chavedoapk">Chave do Apk:</label>
                    <input type="text" value="<?php echo $chavedoapk; ?>" id="chavedoapk" name="chavedoapk" required>
                    
                    <label for="tipodedispositivo">Tipo de Dispositivo:</label>
                    <input type="text" value="<?php echo $tipodedispositivo; ?>" id="tipodedispositivo" name="tipodedispositivo" required>
                    
                    <label for="indicacao">Indicação:</label>
                    <input type="text" value="<?php echo $indicacao; ?>" id="indicacao" name="indicacao" required>
                    
                    <button type="submit">Salvar</button>
                </form>


            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<script>
document.addEventListener("DOMContentLoaded", function() {
    var macAddressInput = document.getElementById("macdoapk");

    macAddressInput.addEventListener("input", function(e) {
        var value = e.target.value.replace(/[^a-fA-F0-9]/g, "").toUpperCase();
        var formattedValue = "";

        for (var i = 0; i < value.length; i++) {
            formattedValue += value[i];
            if ((i + 1) % 2 === 0 && i < value.length - 1) {
                formattedValue += ":";
            }
        }

        e.target.value = formattedValue;
    });
});
</script>