<?php 
session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}

// Função para sanitizar entradas de texto
function sanitizeInput($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

$db_check = new SQLite3('.listausuarios.db');
$db_check->exec('CREATE TABLE IF NOT EXISTS USERS(
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    nome TEXT,
    descricao TEXT, 
    whatsapp TEXT, 
    datavencimento TEXT, 
    datainicio TEXT, 
    servidor TEXT, 
    conexao TEXT, 
    nomedoapk TEXT, 
    macdoapk TEXT, 
    chavedoapk TEXT, 
    tipodedispositivo TEXT, 
    indicacao TEXT
)');

// Função para validar e criar um usuário
function criarUsuario($nome, $descricao, $whatsapp, $datavencimento, $datainicio, $servidor, $conexao, $nomedoapk, $macdoapk, $chavedoapk, $tipodedispositivo, $indicacao) {
    $db_check = new SQLite3('.listausuarios.db');
    $db_check->exec('CREATE TABLE IF NOT EXISTS USERS(
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        nome TEXT,
        descricao TEXT, 
        whatsapp TEXT, 
        datavencimento TEXT, 
        datainicio TEXT, 
        servidor TEXT, 
        conexao TEXT, 
        nomedoapk TEXT, 
        macdoapk TEXT, 
        chavedoapk TEXT, 
        tipodedispositivo TEXT, 
        indicacao TEXT
    )');

    $stmt = $db_check->prepare('INSERT INTO USERS (nome, descricao, whatsapp, datavencimento, datainicio, servidor, conexao, nomedoapk, macdoapk, chavedoapk, tipodedispositivo, indicacao) VALUES (:nome, :descricao, :whatsapp, :datavencimento, :datainicio, :servidor, :conexao, :nomedoapk, :macdoapk, :chavedoapk, :tipodedispositivo, :indicacao)');
    
    // Atribuindo valores ou NULL se estiver vazio
    $stmt->bindValue(':nome', $nome ?: null, SQLITE3_TEXT);
    $stmt->bindValue(':descricao', $descricao ?: null, SQLITE3_TEXT);
    $stmt->bindValue(':whatsapp', $whatsapp ?: null, SQLITE3_TEXT);
    $stmt->bindValue(':datavencimento', $datavencimento, SQLITE3_TEXT);
    $stmt->bindValue(':datainicio', $datainicio, SQLITE3_TEXT);
    $stmt->bindValue(':servidor', $servidor ?: null, SQLITE3_TEXT);
    $stmt->bindValue(':conexao', $conexao ?: null, SQLITE3_TEXT);
    $stmt->bindValue(':nomedoapk', $nomedoapk ?: null, SQLITE3_TEXT);
    $stmt->bindValue(':macdoapk', $macdoapk ?: null, SQLITE3_TEXT);
    $stmt->bindValue(':chavedoapk', $chavedoapk ?: null, SQLITE3_TEXT);
    $stmt->bindValue(':tipodedispositivo', $tipodedispositivo ?: null, SQLITE3_TEXT);
    $stmt->bindValue(':indicacao', $indicacao ?: null, SQLITE3_TEXT);

    if ($stmt->execute()) {
        echo "<script>alert('O usuário foi adicionado com sucesso.');</script>";
        echo "<script>window.location.href='listausuarios.php?option=iniciar';</script>";
    } else {
        echo "<script>alert('Erro ao criar o usuário.');</script>";
        echo "<script>window.location.href='criar.php';</script>";
    }

    $db_check->close();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nome = sanitizeInput($_POST['nome']);
    $descricao = sanitizeInput($_POST['descricao']);
    $whatsapp = sanitizeInput($_POST['whatsapp']);
    $datavencimento = sanitizeInput($_POST['datavencimento']);
    $datainicio = sanitizeInput($_POST['datainicio']);
    $servidor = sanitizeInput($_POST['servidor']);
    $conexao = sanitizeInput($_POST['conexao']);
    $nomedoapk = sanitizeInput($_POST['nomedoapk']);
    $macdoapk = sanitizeInput($_POST['macdoapk']);
    $chavedoapk = sanitizeInput($_POST['chavedoapk']);
    $tipodedispositivo = sanitizeInput($_POST['tipodedispositivo']);
    $indicacao = sanitizeInput($_POST['indicacao']);

    // Verifica se os campos obrigatórios estão preenchidos
    if (!empty($datainicio) && !empty($datavencimento)) {
        criarUsuario($nome, $descricao, $whatsapp, $datavencimento, $datainicio, $servidor, $conexao, $nomedoapk, $macdoapk, $chavedoapk, $tipodedispositivo, $indicacao);
    } else {
        echo "<script>alert('Erro: os campos Data de Início e Data de Vencimento são obrigatórios.');</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f4f4;
            color: #333;
        }

        #sidebar {
            background-color: #343a40;
            color: #fff;
            height: 100vh;
        }

        #content {
            padding: 20px;
        }

        h1 {
            font-size: 2.5rem;
            text-align: center;
            color: #007bff;
            margin-bottom: 20px;
        }

        form {
            background-color: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            margin: auto;
        }

        form label {
            font-weight: bold;
            margin-bottom: 10px;
            color: #495057;
        }

        form input {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ced4da;
            border-radius: 15px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        form input:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
            outline: none;
        }

        form button {
            width: 100%;
            padding: 10px;
            background-color: #28a745;
            color: #fff;
            border: none;
            border-radius: 5px;
            font-size: 1.2rem;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        form button:hover {
            background-color: #218838;
        }

        table {
            width: 100%;
            margin-top: 30px;
            border-collapse: collapse;
        }

        table th, table td {
            padding: 12px;
            text-align: left;
            border: 1px solid #dee2e6;
        }

        table th {
            background-color: #007bff;
            color: white;
        }

        @media (max-width: 768px) {
            form {
                padding: 20px;
            }

            h1 {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'laterais.php'; ?>
            <main role="main" class="col-md-9 col-lg-10 px-md-4" id="content">
                <h1>Cadastro</h1>
                <form action="criar.php?token=criaruser" method="post">
                    <label for="nome">Nome do Cliente:</label>
                    <input type="text" id="nome" name="nome">
                    
                    <label for="whatsapp">Whatsapp:</label>
                    <input type="text" id="whatsapp" name="whatsapp">
                                        
                    <label for="descricao">Valor Pago:</label>
                    <input type="text" id="descricao" name="descricao">
                                        
                    <label for="datainicio">Data de Início:</label>
                    <input type="date" id="datainicio" name="datainicio" required>
                    
                    <label for="datavencimento">Data de Vencimento:</label>
                    <input type="date" id="datavencimento" name="datavencimento" required>
                                        
                    <label for="servidor">Servidor:</label>
                    <input type="text" id="servidor" name="servidor">
                    
                    <label for="conexao">Conexão:</label>
                    <input type="text" id="conexao" name="conexao">
                    
                    <label for="nomedoapk">Nome do APK:</label>
                    <input type="text" id="nomedoapk" name="nomedoapk">
                    
                    <label for="macdoapk">MAC do APK:</label>
                    <input type="text" id="macdoapk" name="macdoapk">
                    
                    <label for="chavedoapk">Chave do APK:</label>
                    <input type="text" id="chavedoapk" name="chavedoapk">
                    
                    <label for="tipodedispositivo">Tipo de Dispositivo:</label>
                    <input type="text" id="tipodedispositivo" name="tipodedispositivo">
                    
                    <label for="indicacao">Indicação:</label>
                    <input type="text" id="indicacao" name="indicacao">
                    
                    <button type="submit">Cadastrar Usuário</button>
                </form>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<script>
document.addEventListener("DOMContentLoaded", function() {
    var dataInicioInput = document.getElementById("datainicio");
    var dataVencimentoInput = document.getElementById("datavencimento");

    var hoje = new Date();
    var dataInicio = hoje.toISOString().split('T')[0];  // Data atual no formato YYYY-MM-DD
    dataInicioInput.value = dataInicio;

    var dataVencimento = new Date(hoje.setMonth(hoje.getMonth() + 1)).toISOString().split('T')[0];  // Data de 1 mês à frente
    dataVencimentoInput.value = dataVencimento;
});
</script>
