<?php
// Caminho para o banco de dados SQLite
$dbFile = '.listausuarios.db';

// Função para realizar o download do arquivo de banco de dados original
function downloadBancoDadosOriginal($dbFile) {
    if (file_exists($dbFile)) {
        // Cabeçalhos para forçar o download do arquivo SQLite
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="backup_banco_de_dados.db"');
        header('Content-Length: ' . filesize($dbFile));

        // Lê o arquivo e envia para o navegador
        readfile($dbFile);
        exit;
    } else {
        echo "Erro: O arquivo do banco de dados não foi encontrado.";
    }
}

// Verifica se o download foi solicitado
if (isset($_GET['download'])) {
    downloadBancoDadosOriginal($dbFile);
}

// Função para upload do banco de dados (reposição do arquivo original)
function uploadBancoDadosOriginal($dbFile) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['arquivo'])) {
        $arquivoTemp = $_FILES['arquivo']['tmp_name'];

        // Verifica se o arquivo foi carregado com sucesso
        if (file_exists($arquivoTemp)) {
            // Sobrescreve o banco de dados original com o novo arquivo enviado
            move_uploaded_file($arquivoTemp, $dbFile);
            echo "Upload realizado com sucesso!";
        } else {
            echo "Erro ao enviar o arquivo.";
        }
    }
}

// Verifica se o upload foi solicitado
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['arquivo'])) {
    uploadBancoDadosOriginal($dbFile);
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Backup e Upload do Banco de Dados</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f4f8;
            padding: 20px;
            animation: fadeIn 1s ease-in-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        h1 {
            color: #4a4a4a;
            text-align: center;
            margin-bottom: 30px;
        }

        .button {
            padding: 15px 30px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            transition: background-color 0.3s ease-in-out;
            cursor: pointer;
        }

        .button:hover {
            background-color: #218838;
            transform: scale(1.05);
        }

        .upload-section {
            margin-top: 30px;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        .upload-section h2 {
            color: #343a40;
        }

        input[type="file"] {
            margin-bottom: 20px;
            padding: 10px;
            font-size: 16px;
            width: 100%;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        .upload-button {
            background-color: #17a2b8;
            color: white;
        }

        .upload-button:hover {
            background-color: #138496;
        }

        .download-section {
            text-align: center;
            margin-bottom: 30px;
        }

        .download-button {
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            padding: 15px 30px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s ease-in-out;
        }

        .download-button:hover {
            background-color: #0056b3;
            transform: scale(1.05);
        }

        .icon {
            margin-right: 8px;
        }

    </style>
</head>
<body>

<h1>Backup e Upload do Banco de Dados</h1>

<!-- Seção de download -->
<div class="download-section">
    <form method="GET" action="">
        <button type="submit" name="download" class="download-button">
            <i class="fas fa-download icon"></i> Download do Banco de Dados Original
        </button>
    </form>
</div>

<!-- Seção de upload -->
<div class="upload-section">
    <h2>Upload do Banco de Dados</h2>
    <form method="POST" enctype="multipart/form-data">
        <input type="file" name="arquivo" accept=".db" required>
        <button type="submit" class="button upload-button">
            <i class="fas fa-upload icon"></i> Enviar Banco de Dados
        </button>
    </form>
</div>

</body>
</html>
