<?php
session_start();

// Verifica se o usuário não está autenticado; se não estiver, redireciona para o login
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Define o diretório onde as imagens serão salvas
$upload_dir = 'uploads/';

// Verifica se o diretório existe, se não, cria
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0755, true);
}

// Processa o upload da imagem de fundo
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Processa o upload da imagem de fundo
    if (isset($_FILES['background']) && $_FILES['background']['error'] == UPLOAD_ERR_OK) {
        // Substitui qualquer imagem de fundo existente
        $background_file = $upload_dir . 'background.jpg'; // Nome fixo para a imagem de fundo
        move_uploaded_file($_FILES['background']['tmp_name'], $background_file);
        // Aqui você pode adicionar código para salvar o caminho da imagem de fundo em um arquivo ou banco de dados
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload de Imagens</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            padding: 20px;
            background-image: url('<?php echo $upload_dir . 'background.jpg'; ?>');
            background-size: cover;
            background-position: center;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            position: relative;
            z-index: 1;
        }
        h2 {
            margin-bottom: 20px;
            color: #333;
        }
        input[type="file"] {
            display: block;
            margin-bottom: 10px;
        }
        button, .back-button {
            display: inline-block;
            padding: 10px 15px;
            font-size: 16px;
            color: #fff;
            background-color: #007bff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-align: center;
            text-decoration: none;
            transition: background-color 0.3s, transform 0.3s;
            margin-top: 10px;
        }
        button:hover, .back-button:hover {
            background-color: #0056b3;
            transform: scale(1.05);
        }
        .back-button {
            background-color: #6c757d;
            margin-left: 10px;
        }
        .back-button:hover {
            background-color: #5a6268;
        }
        .button-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Upload de Imagem de Fundo</h2>
        
        <!-- Formulário para carregar a imagem de fundo -->
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" enctype="multipart/form-data">
            <div class="form-group">
                <label for="background">Carregar Imagem de Fundo:</label>
                <input type="file" id="background" name="background" accept="image/*" required>
            </div>
            <div class="button-container">
                <button type="submit">Carregar Imagem de Fundo</button>
                <a href="settings.php" class="back-button">Voltar</a>
            </div>
        </form>
    </div>
</body>
</html>
