<?php
// edit_category.php

// Carrega a lista de categorias
function loadButtons() {
    $data = [
        'buttons' => [],
        'categories' => []
    ];

    if (file_exists('buttons.json')) {
        $data = json_decode(file_get_contents('buttons.json'), true);
    }

    return $data;
}

// Obtém o índice da categoria a ser editada do GET
if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET['edit_index'])) {
    $edit_index = $_GET['edit_index'];

    // Carrega as categorias existentes
    $data = loadButtons();
    $categories = $data['categories'];

    // Verifica se o índice é válido
    if (isset($categories[$edit_index])) {
        $category_to_edit = $categories[$edit_index];
    } else {
        // Se o índice não for válido, redireciona de volta à lista de categorias
        header('Location: settings.php');
        exit;
    }
} elseif ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_category'])) {
    $edit_index = $_POST['edit_index'];
    $new_category_name = $_POST['category_name'];

    // Carrega as categorias existentes
    $data = loadButtons();
    $categories = $data['categories'];

    // Atualiza a categoria
    if (isset($categories[$edit_index])) {
        $categories[$edit_index] = $new_category_name;
        $data['categories'] = $categories;
        file_put_contents('buttons.json', json_encode($data, JSON_PRETTY_PRINT));
    }

    // Redireciona de volta para a página de configurações
    header('Location: settings.php');
    exit;
} else {
    // Se não houver índice para editar, redireciona de volta à lista de categorias
    header('Location: settings.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Categoria</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f2f5;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 50px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
            color: #007bff;
        }
        form {
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input[type="text"] {
            width: 100%;
            padding: 10px;
            font-size: 1rem;
            border: 1px solid #ddd;
            border-radius: 5px;
            transition: border-color 0.3s;
        }
        input[type="text"]:focus {
            border-color: #007bff;
            outline: none;
        }
        button {
            width: 100%;
            padding: 10px;
            font-size: 1rem;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        button:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Editar Categoria</h2>

        <!-- Formulário para editar a categoria -->
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
            <div class="form-group">
                <label for="category_name">Nome da Categoria:</label>
                <input type="text" id="category_name" name="category_name" value="<?php echo htmlspecialchars($category_to_edit); ?>" required>
            </div>
            <button type="submit" name="update_category">Atualizar Categoria</button>
            <input type="hidden" name="edit_index" value="<?php echo htmlspecialchars($edit_index); ?>">
        </form>

        <!-- Botão para voltar -->
        <div style="text-align: center;">
            <a href="settings.php">Voltar à Configurações</a>
        </div>
    </div>
</body>
</html>
